﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using RevisionAnalyser.Global.EasterEgg;

namespace RevisionAnalyser
{
    public partial class AboutForm : Form
    {
        private KonamiSequence sequence = new KonamiSequence();

        public AboutForm()
        {
            InitializeComponent();
        }

        private void uxCloseButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void uxEmail_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Process.Start("mailto:" + ((LinkLabel)sender).Text);
            }
            catch
            {
                MessageBox.Show("Could not open the default e-mail program. Do you have one installed?", "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void uxPluginsButton_Click(object sender, EventArgs e)
        {
            PluginsForm frmPlugins = new PluginsForm();
            frmPlugins.ShowDialog();
        }

        private void AboutForm_KeyUp(object sender, KeyEventArgs e)
        {
            if (sequence.IsCompletedBy(e.KeyCode))
            {
                SnakeForm frmSnake = new SnakeForm();
                frmSnake.ShowDialog();
            }
        }
    }
}
